/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRBannerProtection;
import lotr.common.LOTRCommonProxy;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDamage;
import lotr.common.LOTRDimension;
import lotr.common.LOTRDrunkenSpeech;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import lotr.common.LOTRTitle;
import lotr.common.block.LOTRBlockUtumnoReturnPortalBase;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.enchant.LOTREnchantmentWeaponSpecial;
import lotr.common.entity.LOTRBannerProtectable;
import lotr.common.entity.LOTREntityRegistry;
import lotr.common.entity.animal.LOTREntityButterfly;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.animal.LOTREntityZebra;
import lotr.common.entity.item.LOTREntityArrowAvari;
import lotr.common.entity.item.LOTREntityArrowExplosion;
import lotr.common.entity.item.LOTREntityArrowHunger;
import lotr.common.entity.item.LOTREntityArrowMorgul;
import lotr.common.entity.item.LOTREntityArrowPoisoned;
import lotr.common.entity.item.LOTREntityArrowSlow;
import lotr.common.entity.item.LOTREntityArrowWeak;
import lotr.common.entity.npc.INotBleeding;
import lotr.common.entity.npc.LOTREntityEreborDwarfBerserker;
import lotr.common.entity.npc.LOTREntityGaladhrimWarden;
import lotr.common.entity.npc.LOTREntityHuornBase;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOlogHai;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntityRanger;
import lotr.common.entity.npc.LOTREntityRohanMan;
import lotr.common.entity.npc.LOTREntityWargBombardier;
import lotr.common.entity.npc.LOTREntityWindDwarfAxeThrower;
import lotr.common.entity.npc.LOTRMercenary;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.entity.projectile.LOTREntityCrossbowBolt;
import lotr.common.entity.projectile.LOTREntityDart;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.entity.projectile.LOTREntityThrowingAxe;
import lotr.common.entity.projectile.LOTREntityThrowingAxe2;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.fac.LOTRFactionBounties;
import lotr.common.item.LOTREntityArrowFall;
import lotr.common.item.LOTREntityArrowFire;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemBrandingIron;
import lotr.common.item.LOTRItemDagger;
import lotr.common.item.LOTRItemDye;
import lotr.common.item.LOTRItemMug;
import lotr.common.item.LOTRItemPouch;
import lotr.common.item.LOTRMaterial;
import lotr.common.item.LOTRWeaponStats;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketStopItemUse;
import lotr.common.network.LOTRPacketUtumnoKill;
import lotr.common.network.LOTRPacketWeaponFX;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.world.structure2.LOTRStructureTimelapse;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class LOTREventHandler3
implements IFuelHandler {
    private LOTRItemBow proxyBowItemServer;
    private LOTRItemBow proxyBowItemClient;

    public LOTREventHandler3() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        new LOTRStructureTimelapse();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("lotr")) {
            LOTRConfig.load();
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityPlayer entityplayer = event.player;
        World world = entityplayer.field_70170_p;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        EntityMinecart minecart = event.minecart;
        if (minecart instanceof EntityMinecartChest && itemstack != null && itemstack.func_77973_b() instanceof LOTRItemPouch) {
            if (!world.field_72995_K) {
                int pouchSlot = entityplayer.field_71071_by.field_70461_c;
                entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.packGuiIDWithSlot(64, pouchSlot), world, minecart.func_145782_y(), 0, 0);
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        String playerName;
        UUID brandingPlayer;
        EntityPlayer entityplayer = event.entityPlayer;
        World world = entityplayer.field_70170_p;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        Entity entity = event.target;
        if (!world.field_72995_K && (entity instanceof EntityHanging || entity instanceof LOTRBannerProtectable) && LOTRBannerProtection.isProtected(world, entity, LOTRBannerProtection.forPlayer(entityplayer, LOTRBannerProtection.Permission.FULL), true)) {
            event.setCanceled(true);
            return;
        }
        if ((entity instanceof EntityCow || entity instanceof LOTREntityZebra) && itemstack != null && LOTRItemMug.isItemEmptyDrink(itemstack)) {
            LOTRItemMug.Vessel vessel = LOTRItemMug.getVessel(itemstack);
            ItemStack milkItem = new ItemStack(LOTRMod.mugMilk);
            LOTRItemMug.setVessel(milkItem, vessel, true);
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0 || entityplayer.field_71075_bZ.field_75098_d) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, milkItem);
            } else if (!entityplayer.field_71071_by.func_70441_a(milkItem)) {
                entityplayer.func_71019_a(milkItem, false);
            }
            event.setCanceled(true);
            return;
        }
        if (entity instanceof EntityWolf) {
            int dyeType;
            Item prevItem;
            EntityWolf wolf = (EntityWolf)entity;
            if (itemstack != null && LOTRMod.isOreNameEqual(itemstack, "bone") && itemstack.func_77973_b() != Items.field_151103_aS) {
                prevItem = itemstack.func_77973_b();
                itemstack.func_150996_a(Items.field_151103_aS);
                boolean flag = wolf.func_70085_c(entityplayer);
                itemstack.func_150996_a(prevItem);
                if (flag) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (itemstack != null && (dyeType = LOTRItemDye.isItemDye(itemstack)) >= 0 && itemstack.func_77973_b() != Items.field_151100_aR) {
                prevItem = itemstack.func_77973_b();
                int prevMeta = itemstack.func_77960_j();
                itemstack.func_150996_a(Items.field_151100_aR);
                itemstack.func_77964_b(dyeType);
                boolean flag = wolf.func_70085_c(entityplayer);
                itemstack.func_150996_a(prevItem);
                itemstack.func_77964_b(prevMeta);
                if (flag) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (entity instanceof LOTRTradeable && ((LOTRTradeable)entity).canTradeWith(entityplayer)) {
            if (entity instanceof LOTRUnitTradeable) {
                entityplayer.openGui((Object)LOTRMod.instance, 24, world, entity.func_145782_y(), 0, 0);
            } else {
                entityplayer.openGui((Object)LOTRMod.instance, 19, world, entity.func_145782_y(), 0, 0);
            }
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTRUnitTradeable && ((LOTRUnitTradeable)entity).canTradeWith(entityplayer)) {
            entityplayer.openGui((Object)LOTRMod.instance, 20, world, entity.func_145782_y(), 0, 0);
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTRMercenary && ((LOTRMercenary)entity).canTradeWith(entityplayer) && ((LOTREntityNPC)entity).hiredNPCInfo.getHiringPlayerUUID() == null) {
            entityplayer.openGui((Object)LOTRMod.instance, 58, world, entity.func_145782_y(), 0, 0);
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTREntityNPC) {
            LOTREntityNPC npc = (LOTREntityNPC)entity;
            if (npc.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                entityplayer.openGui((Object)LOTRMod.instance, 21, world, entity.func_145782_y(), 0, 0);
                event.setCanceled(true);
                return;
            }
            if (npc.hiredNPCInfo.isActive && entityplayer.field_71075_bZ.field_75098_d && itemstack != null && itemstack.func_77973_b() == Items.field_151113_aN) {
                String playerName2;
                UUID hiringUUID;
                if (!world.field_72995_K && MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entityplayer.func_146103_bH()) && (hiringUUID = npc.hiredNPCInfo.getHiringPlayerUUID()) != null && (playerName2 = LOTREventHandler3.getUsernameWithoutWebservice(hiringUUID)) != null) {
                    ChatComponentText msg = new ChatComponentText("Hired unit belongs to " + playerName2);
                    msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                    entityplayer.func_145747_a((IChatComponent)msg);
                }
                event.setCanceled(true);
                return;
            }
        }
        if (!world.field_72995_K && entityplayer.field_71075_bZ.field_75098_d && MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entityplayer.func_146103_bH()) && itemstack != null && itemstack.func_77973_b() == Items.field_151113_aN && entity instanceof EntityLiving && (brandingPlayer = LOTRItemBrandingIron.getBrandingPlayer(entity)) != null && (playerName = LOTREventHandler3.getUsernameWithoutWebservice(brandingPlayer)) != null) {
            ChatComponentText msg = new ChatComponentText("Entity was branded by " + playerName);
            msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            entityplayer.func_145747_a((IChatComponent)msg);
            event.setCanceled(true);
            return;
        }
        if (entity instanceof EntityVillager && !LOTRConfig.enableVillagerTrading) {
            event.setCanceled(true);
            return;
        }
    }

    public static String getUsernameWithoutWebservice(UUID player) {
        GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(player);
        if (profile != null && !StringUtils.isBlank((CharSequence)profile.getName())) {
            return profile.getName();
        }
        String cachedName = UsernameCache.getLastKnownUsername((UUID)player);
        if (cachedName != null && !StringUtils.isBlank((CharSequence)cachedName)) {
            return cachedName;
        }
        return player.toString();
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        boolean sneaking = false;
        if (event.target instanceof LOTREntityRanger && ((LOTREntityRanger)event.target).isRangerSneaking()) {
            sneaking = true;
        }
        if (event.target instanceof LOTREntityGaladhrimWarden && ((LOTREntityGaladhrimWarden)event.target).isElfSneaking()) {
            sneaking = true;
        }
        if (event.target instanceof LOTREntityHuornBase && !((LOTREntityHuornBase)event.target).isHuornActive()) {
            sneaking = true;
        }
        if (event.target instanceof EntityPlayer) {
            boolean cloak;
            EntityPlayer entityplayer = (EntityPlayer)event.target;
            boolean bl = cloak = LOTRLevelData.getData((EntityPlayer)event.target).isPlayerWearingFull(entityplayer) == LOTRMaterial.HITHLAIN;
            if (cloak && entityplayer.func_110144_aD() != event.entityLiving && entityplayer.func_70068_e((Entity)event.entityLiving) >= 64.0) {
                sneaking = true;
            }
        }
        if (event.entityLiving instanceof EntityLiving && sneaking) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onEntityAttackedByPlayer(AttackEntityEvent event) {
        Entity entity = event.target;
        World world = entity.field_70170_p;
        EntityPlayer entityplayer = event.entityPlayer;
        if (!world.field_72995_K && (entity instanceof EntityHanging || entity instanceof LOTRBannerProtectable) && LOTRBannerProtection.isProtected(world, entity, LOTRBannerProtection.forPlayer(entityplayer, LOTRBannerProtection.Permission.FULL), true)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        EntityLivingBase entity = event.entityLiving;
        EntityLivingBase attacker = event.source.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)event.source.func_76346_g() : null;
        World world = entity.field_70170_p;
        if (entity instanceof LOTRNPCMount && entity.field_70153_n != null && attacker == entity.field_70153_n) {
            this.cancelAttackEvent(event);
        }
        if (attacker instanceof EntityPlayer && !LOTRMod.canPlayerAttackEntity((EntityPlayer)attacker, entity, true)) {
            this.cancelAttackEvent(event);
        }
        if (attacker instanceof EntityCreature && !LOTRMod.canNPCAttackEntity((EntityCreature)attacker, entity, false)) {
            this.cancelAttackEvent(event);
        }
        if (event.source instanceof EntityDamageSourceIndirect) {
            ItemStack chestplate;
            Entity projectile = event.source.func_76364_f();
            if (projectile instanceof EntityArrow || projectile instanceof LOTREntityCrossbowBolt || projectile instanceof LOTREntityDart) {
                boolean wearingAllGalvorn = true;
                for (int i = 0; i < 4; ++i) {
                    ItemStack armour = entity.func_71124_b(i + 1);
                    if (armour != null && armour.func_77973_b() instanceof ItemArmor && ((ItemArmor)armour.func_77973_b()).func_82812_d() == LOTRMaterial.GALVORN.toArmorMaterial()) continue;
                    wearingAllGalvorn = false;
                    break;
                }
                if (wearingAllGalvorn) {
                    if (!world.field_72995_K && entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).field_71071_by.func_70449_g(event.ammount);
                    }
                    this.cancelAttackEvent(event);
                }
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && attacker instanceof LOTREntityOrc && projectile instanceof LOTREntitySpear && (chestplate = entity.func_71124_b(3)) != null && chestplate.func_77973_b() == LOTRMod.bodyDMithril) {
                LOTRLevelData.getData((EntityPlayer)entity).addAchievement(LOTRAchievement.hitByOrcSpear);
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && attacker instanceof LOTREntityOrc && projectile instanceof LOTREntitySpear && (chestplate = entity.func_71124_b(3)) != null && chestplate.func_77973_b() == LOTRMod.bodyMithril) {
                LOTRLevelData.getData((EntityPlayer)entity).addAchievement(LOTRAchievement.hitByOrcSpear);
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && attacker instanceof LOTREntityOrc && projectile instanceof LOTREntitySpear && (chestplate = entity.func_71124_b(3)) != null && chestplate.func_77973_b() == LOTRMod.bodyMoriaMithril) {
                LOTRLevelData.getData((EntityPlayer)entity).addAchievement(LOTRAchievement.hitByOrcSpear);
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && attacker instanceof LOTREntityOrc && projectile instanceof LOTREntitySpear && (chestplate = entity.func_71124_b(3)) != null && chestplate.func_77973_b() == LOTRMod.bodyBilbo) {
                LOTRLevelData.getData((EntityPlayer)entity).addAchievement(LOTRAchievement.hitByOrcSpear);
            }
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null && player.func_70005_c_().equals("FirstKalik") && Keyboard.isKeyDown((int)42)) {
            ItemStack item = event.itemStack;
            Item itemObj = item.func_77973_b();
            String itemId = Item.field_150901_e.func_148750_c((Object)itemObj);
            event.toolTip.add("\u00a7b Class");
            if (itemObj instanceof ItemBlock) {
                event.toolTip.add("\u00a7b " + Block.func_149634_a((Item)itemObj).getClass().getName());
            } else {
                event.toolTip.add("\u00a7b  " + itemObj.getClass().getName());
            }
            event.toolTip.add("\u00a7b Name ID");
            event.toolTip.add("\u00a7b  " + itemId);
        }
    }

    private void cancelAttackEvent(LivingAttackEvent event) {
        event.setCanceled(true);
        DamageSource source = event.source;
        if (source instanceof EntityDamageSourceIndirect) {
            source.func_76364_f();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LOTRPacketWeaponFX packet;
        EntityLivingBase entity = event.entityLiving;
        EntityLivingBase attacker = event.source.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)event.source.func_76346_g() : null;
        World world = entity.field_70170_p;
        if (entity instanceof EntityPlayerMP && event.source == LOTRDamage.frost) {
            LOTRDamage.doFrostDamage((EntityPlayerMP)entity);
        }
        if (!world.field_72995_K) {
            ItemStack weapon;
            int maxHurtResTime;
            int preMaxHurtResTime = entity.field_70771_an;
            boolean hasVulnerabilityEffect = entity.func_70644_a(LOTRPotions.vulnerability);
            int n = maxHurtResTime = hasVulnerabilityEffect ? 10 : 20;
            if (attacker != null && LOTRWeaponStats.isMeleeWeapon(weapon = attacker.func_70694_bm())) {
                maxHurtResTime = hasVulnerabilityEffect ? 10 : LOTRWeaponStats.getAttackTimeWithBase(weapon, 20);
            }
            entity.field_70771_an = Math.min(maxHurtResTime, 20);
            if (entity.field_70172_ad == preMaxHurtResTime) {
                entity.field_70172_ad = maxHurtResTime;
            }
        }
        if (attacker != null && event.source.func_76364_f() == attacker) {
            ItemStack usingItem;
            EntityPlayerMP entityplayer;
            ItemStack weapon = attacker.func_70694_bm();
            if (!world.field_72995_K && entity instanceof EntityPlayerMP && (entityplayer = (EntityPlayerMP)entity).func_71039_bw() && (usingItem = entityplayer.func_70694_bm()) != null && LOTRWeaponStats.isRangedWeapon(usingItem)) {
                entityplayer.func_71041_bz();
                LOTRPacketStopItemUse packet2 = new LOTRPacketStopItemUse();
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet2, entityplayer);
            }
            boolean wearingAllMorgul = true;
            for (int i = 0; i < 4; ++i) {
                ItemStack armour = entity.func_71124_b(i + 1);
                if (armour != null && armour.func_77973_b() instanceof ItemArmor && ((ItemArmor)armour.func_77973_b()).func_82812_d() == LOTRMaterial.MORGUL.toArmorMaterial()) continue;
                wearingAllMorgul = false;
                break;
            }
            if (wearingAllMorgul && !world.field_72995_K && weapon != null && weapon.func_77984_f()) {
                int damage = weapon.func_77960_j();
                int maxDamage = weapon.func_77958_k();
                float durability = 1.0f - (float)damage / (float)maxDamage;
                int newDamage = Math.round((1.0f - (durability *= 0.9f)) * (float)maxDamage);
                newDamage = Math.min(newDamage, maxDamage);
                weapon.func_77972_a(newDamage - damage, attacker);
            }
            EntityLivingBase victim = event.entityLiving;
            World world1 = victim.field_70170_p;
            boolean wearingGULDUR1 = false;
            for (int i = 0; i < 4; ++i) {
                ItemStack armour = victim.func_71124_b(i + 1);
                if (armour == null || !(armour.func_77973_b() instanceof ItemArmor) || ((ItemArmor)armour.func_77973_b()).func_82812_d() != LOTRMaterial.GULDUR1.toArmorMaterial()) continue;
                wearingGULDUR1 = true;
                break;
            }
            if (wearingGULDUR1 && !world.field_72995_K) {
                Entity attacker1 = event.source.func_76346_g();
                float random = world.field_73012_v.nextFloat();
                if (attacker1 instanceof EntityLivingBase && random < 0.1f) {
                    ((EntityLivingBase)attacker1).func_70690_d(new PotionEffect(LOTRPotions.vulnerability.func_76396_c(), 360, 0));
                    ((EntityLivingBase)attacker1).func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 360, 0));
                }
                if (random < 0.1f) {
                    victim.func_70690_d(new PotionEffect(LOTRPotions.meleeDamageBoostSauron.func_76396_c(), 360, 0));
                }
            }
            if (weapon != null) {
                Item.ToolMaterial material = null;
                if (weapon.func_77973_b() instanceof ItemTool) {
                    material = ((ItemTool)weapon.func_77973_b()).func_150913_i();
                } else if (weapon.func_77973_b() instanceof ItemSword) {
                    material = LOTRMaterial.getToolMaterialByName(((ItemSword)weapon.func_77973_b()).func_150932_j());
                }
                if (material != null && material == LOTRMaterial.MORGUL.toToolMaterial() && !world.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 160));
                }
                if (material != null && LOTRConfig.enableBleeding && material == LOTRMaterial.AVARI_ELVEN_DAGGER.toToolMaterial() && !world.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(LOTRPotions.blood.field_76415_H, (world.field_73012_v.nextInt(8) + 16) * 20));
                }
                if (material != null && LOTRConfig.enableBleeding && !world.field_72995_K && !(entity instanceof INotBleeding)) {
                    int[] chances = new int[]{18, 40, 80};
                    for (int level = 0; level < chances.length; ++level) {
                        if (world.field_73012_v.nextInt(chances[level]) != 0) continue;
                        entity.func_70690_d(new PotionEffect(LOTRPotions.blood.field_76415_H, (world.field_73012_v.nextInt(8) + 16) * 20, level));
                        break;
                    }
                }
            }
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowPoisoned && !world.field_72995_K) {
            LOTRItemDagger.applyStandardPoison(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowMorgul && !world.field_72995_K) {
            LOTRItemDagger.applyStandardPoison1(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowFire) {
            packet = new LOTRPacketWeaponFX(LOTRPacketWeaponFX.Type.INFERNAL, (Entity)entity);
            LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)entity, 64.0));
        }
        if (event.source.func_76364_f() instanceof LOTREntityThrowingAxe2 && !world.field_72995_K) {
            LOTRItemDagger.applyStandardWeak(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowHunger && !world.field_72995_K) {
            LOTRItemDagger.applyStandardHunger(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowFall && !world.field_72995_K) {
            LOTRItemDagger.applyStandardFall(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowWeak && !world.field_72995_K) {
            LOTRItemDagger.applyStandardWeak(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowSlow && !world.field_72995_K) {
            LOTRItemDagger.applyStandardSlow(entity);
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowExplosion && !world.field_72995_K) {
            LOTRItemDagger.applyStandardExplosion(entity);
            packet = new LOTRPacketWeaponFX(LOTRPacketWeaponFX.Type.MACE_SAURON, (Entity)entity);
            LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)entity, 64.0));
        }
        if (event.source.func_76364_f() instanceof LOTREntityArrowAvari && !world.field_72995_K) {
            LOTRItemDagger.applyStandardBlood(entity);
        }
        if (!world.field_72995_K) {
            if (LOTREnchantmentHelper.hasMeleeOrRangedEnchant(event.source, LOTREnchantment.fire)) {
                packet = new LOTRPacketWeaponFX(LOTRPacketWeaponFX.Type.INFERNAL, (Entity)entity);
                LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)entity, 64.0));
            }
            if (LOTREnchantmentHelper.hasMeleeOrRangedEnchant(event.source, LOTREnchantment.chill)) {
                LOTREnchantmentWeaponSpecial.doChillAttack(entity);
            }
            if (LOTREnchantmentHelper.hasMeleeOrRangedEnchant(event.source, LOTREnchantment.wither)) {
                LOTREnchantmentWeaponSpecial.doPoisonAttack(entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity attacker;
        int k;
        int j;
        int i;
        EntityPlayer entityplayer;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        DamageSource source = event.source;
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)entity;
            world.func_72956_a((Entity)entityplayer, "lotr:item.death", 10.0f, 1.0f);
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.playerDeath);
            i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
            j = MathHelper.func_76128_c((double)entityplayer.field_70163_u);
            k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
            LOTRLevelData.getData(entityplayer).setDeathPoint(i, j, k);
            LOTRLevelData.getData(entityplayer).setDeathDimension(entityplayer.field_71093_bK);
        }
        if (!world.field_72995_K) {
            entityplayer = null;
            boolean creditHiredUnit = false;
            boolean byNearbyUnit = false;
            if (source.func_76346_g() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)source.func_76346_g();
            } else if (entity.func_94060_bK() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)entity.func_94060_bK();
            } else if (source.func_76346_g() instanceof LOTREntityNPC) {
                LOTREntityNPC npc = (LOTREntityNPC)source.func_76346_g();
                if (npc.hiredNPCInfo.isActive && npc.hiredNPCInfo.getHiringPlayer() != null) {
                    entityplayer = npc.hiredNPCInfo.getHiringPlayer();
                    creditHiredUnit = true;
                    double nearbyDist = 64.0;
                    boolean bl = byNearbyUnit = npc.func_70068_e((Entity)entityplayer) <= nearbyDist * nearbyDist;
                }
            }
            if (entityplayer != null) {
                LOTRPlayerData playerData = LOTRLevelData.getData(entityplayer);
                final LOTRFaction entityFaction = LOTRMod.getNPCFaction((Entity)entity);
                float prevAlignment = playerData.getAlignment(entityFaction);
                List<LOTRFaction> forcedBonusFactions = null;
                if (entity instanceof LOTREntityNPC) {
                    forcedBonusFactions = ((LOTREntityNPC)entity).killBonusFactions;
                }
                boolean wasSelfDefenceAgainstAlliedUnit = false;
                if (!creditHiredUnit && prevAlignment > 0.0f && entity instanceof LOTREntityNPC) {
                    LOTREntityNPC npc = (LOTREntityNPC)entity;
                    if (npc.hiredNPCInfo.isActive && npc.hiredNPCInfo.wasAttackCommanded) {
                        wasSelfDefenceAgainstAlliedUnit = true;
                    }
                }
                LOTRAlignmentValues.AlignmentBonus alignmentBonus = null;
                if (!wasSelfDefenceAgainstAlliedUnit) {
                    if (entity instanceof LOTREntityNPC) {
                        LOTREntityNPC npc = (LOTREntityNPC)entity;
                        alignmentBonus = new LOTRAlignmentValues.AlignmentBonus(npc.getAlignmentBonus(), npc.getEntityClassName());
                        alignmentBonus.needsTranslation = true;
                        alignmentBonus.isCivilianKill = npc.isCivilianNPC();
                    } else {
                        String s = EntityList.func_75621_b((Entity)entity);
                        Object obj = LOTREntityRegistry.registeredNPCs.get(s);
                        if (obj != null) {
                            LOTREntityRegistry.RegistryInfo info = (LOTREntityRegistry.RegistryInfo)obj;
                            alignmentBonus = info.alignmentBonus;
                            alignmentBonus.isCivilianKill = false;
                        }
                    }
                }
                if (creditHiredUnit || wasSelfDefenceAgainstAlliedUnit) {
                    // empty if block
                }
                if (alignmentBonus != null && alignmentBonus.bonus != 0.0f && (!creditHiredUnit || creditHiredUnit && byNearbyUnit)) {
                    alignmentBonus.isKill = true;
                    if (creditHiredUnit) {
                        alignmentBonus.killByHiredUnit = true;
                    }
                    playerData.addAlignment(entityplayer, alignmentBonus, entityFaction, forcedBonusFactions, (Entity)entity);
                }
                if (!creditHiredUnit) {
                    if (entityFaction.allowPlayer) {
                        LOTRFaction pledgeFac;
                        playerData.getFactionData(entityFaction).addNPCKill();
                        List<LOTRFaction> killBonuses = entityFaction.getBonusesForKilling();
                        for (LOTRFaction enemy : killBonuses) {
                            playerData.getFactionData(enemy).addEnemyKill();
                        }
                        if (!entityplayer.field_71075_bZ.field_75098_d && entityFaction.inDefinedControlZone(entityplayer, Math.max(entityFaction.getControlZoneReducedRange(), 50))) {
                            LOTRFactionBounties.forFaction(entityFaction).forPlayer(entityplayer).recordNewKill();
                        }
                        if ((pledgeFac = playerData.getPledgeFaction()) != null && (pledgeFac == entityFaction || pledgeFac.isAlly(entityFaction))) {
                            playerData.onPledgeKill(entityplayer);
                        }
                    }
                    float newAlignment = playerData.getAlignment(entityFaction);
                    if (!wasSelfDefenceAgainstAlliedUnit && !entityplayer.field_71075_bZ.field_75098_d && entityFaction != LOTRFaction.UNALIGNED) {
                        int sentSpeeches = 0;
                        int maxSpeeches = 5;
                        double range = 8.0;
                        List nearbyAlliedNPCs = world.func_82733_a(EntityLiving.class, entity.field_70121_D.func_72314_b(range, range, range), new IEntitySelector(){

                            public boolean func_82704_a(Entity entitySelect) {
                                if (entitySelect.func_70089_S()) {
                                    LOTRFaction fac = LOTRMod.getNPCFaction(entitySelect);
                                    return fac.isGoodRelation(entityFaction);
                                }
                                return false;
                            }
                        });
                        for (Object nearbyAlliedNPC : nearbyAlliedNPCs) {
                            LOTREntityNPC lotrnpc;
                            String speech;
                            EntityLiving npc = (EntityLiving)nearbyAlliedNPC;
                            if (npc instanceof LOTREntityNPC && ((LOTREntityNPC)npc).hiredNPCInfo.isActive && newAlignment > 0.0f || npc.func_70638_az() != null) continue;
                            npc.func_70624_b((EntityLivingBase)entityplayer);
                            if (!(npc instanceof LOTREntityNPC) || sentSpeeches >= maxSpeeches || (speech = (lotrnpc = (LOTREntityNPC)npc).getSpeechBank(entityplayer)) == null || lotrnpc.func_70068_e((Entity)entityplayer) >= range) continue;
                            lotrnpc.sendSpeechBank(entityplayer, speech);
                            ++sentSpeeches;
                        }
                    }
                    if (!playerData.isSiegeActive()) {
                        List<LOTRMiniQuest> miniquests = playerData.getMiniQuests();
                        for (LOTRMiniQuest quest : miniquests) {
                            quest.onKill(entityplayer, entity);
                        }
                        if (entity instanceof EntityPlayer) {
                            EntityPlayer slainPlayer = (EntityPlayer)entity;
                            List<LOTRMiniQuest> slainMiniquests = LOTRLevelData.getData(slainPlayer).getMiniQuests();
                            for (LOTRMiniQuest quest : slainMiniquests) {
                                quest.onKilledByPlayer(slainPlayer, entityplayer);
                            }
                        }
                    }
                }
            }
        }
        if (!world.field_72995_K && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer1 = (EntityPlayer)source.func_76346_g();
            LOTREnchantmentHelper.onKillEntity(entityplayer1, entity, source);
        }
        if (!world.field_72995_K && source.func_76346_g() instanceof EntityPlayer && source.func_76364_f() != null && source.func_76364_f().getClass() == LOTREntitySpear.class && entity != (entityplayer = (EntityPlayer)source.func_76346_g()) && entityplayer.func_70068_e((Entity)entity) >= 2500.0) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.useSpearFromFar);
        }
        if (!world.field_72995_K && entity instanceof LOTREntityButterfly && source.func_76346_g() instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)source.func_76346_g();
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.killButterfly);
        }
        if (!world.field_72995_K && entity.getClass() == LOTREntityHorse.class && source.func_76346_g() instanceof EntityPlayer) {
            List rohirrimList;
            entityplayer = (EntityPlayer)source.func_76346_g();
            if (!entityplayer.field_71075_bZ.field_75098_d && !(rohirrimList = world.func_72872_a(LOTREntityRohanMan.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0))).isEmpty()) {
                boolean sentMessage = false;
                boolean penalty = false;
                for (Object element : rohirrimList) {
                    LOTREntityRohanMan rohirrim = (LOTREntityRohanMan)element;
                    if (rohirrim.hiredNPCInfo.isActive && rohirrim.hiredNPCInfo.getHiringPlayer() == entityplayer) continue;
                    rohirrim.func_70624_b((EntityLivingBase)entityplayer);
                    if (!sentMessage) {
                        rohirrim.sendSpeechBank(entityplayer, "rohan/warrior/avengeHorse");
                        sentMessage = true;
                    }
                    if (penalty) continue;
                    LOTRLevelData.getData(entityplayer).addAlignment(entityplayer, LOTRAlignmentValues.ROHAN_HORSE_PENALTY, LOTRFaction.ROHAN, (Entity)entity);
                    penalty = true;
                }
            }
        }
        if (!world.field_72995_K) {
            EntityPlayer attackingPlayer = null;
            LOTREntityNPC attackingHiredUnit = null;
            if (source.func_76346_g() instanceof EntityPlayer) {
                attackingPlayer = (EntityPlayer)source.func_76346_g();
            } else if (source.func_76346_g() instanceof LOTREntityNPC) {
                LOTREntityNPC npc = (LOTREntityNPC)source.func_76346_g();
                if (npc.hiredNPCInfo.isActive && npc.hiredNPCInfo.getHiringPlayer() != null) {
                    attackingPlayer = npc.hiredNPCInfo.getHiringPlayer();
                    attackingHiredUnit = npc;
                }
            }
            if (attackingPlayer != null) {
                boolean isFoe;
                boolean bl = isFoe = LOTRLevelData.getData(attackingPlayer).getAlignment(LOTRMod.getNPCFaction((Entity)entity)) < 0.0f;
                if (isFoe) {
                    if (attackingHiredUnit != null) {
                        if (attackingHiredUnit instanceof LOTREntityWargBombardier) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.hireWargBombardier);
                        }
                        if (attackingHiredUnit instanceof LOTREntityOlogHai) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.hireOlogHai);
                        }
                        if (attackingHiredUnit instanceof LOTREntityEreborDwarfBerserker) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.hireBerserk);
                        }
                        if (attackingHiredUnit instanceof LOTREntityWindDwarfAxeThrower) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.hireWindDwarfAxe);
                        }
                    } else {
                        LOTREntityOrc orc;
                        if (attackingPlayer.func_82165_m(Potion.field_76431_k.field_76415_H) && attackingPlayer.func_82165_m(LOTRPotions.drunk.field_76415_H)) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.killWhileDrunk);
                        }
                        if (entity instanceof LOTREntityOrc && (orc = (LOTREntityOrc)entity).isOrcBombardier() && orc.npcItemsInv.getBomb() != null) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.killBombardier);
                        }
                        if (source.func_76364_f() instanceof LOTREntityCrossbowBolt) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.useCrossbow);
                        }
                        if (source.func_76364_f() instanceof LOTREntityArrowExplosion) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.useArrowExplosion);
                        }
                        if (source.func_76364_f() instanceof LOTREntityArrowFire) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.useArrowFire);
                        }
                        if (source.func_76364_f() instanceof LOTREntityArrowMorgul) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.useArrowMorgul);
                        }
                        if (source.func_76364_f() instanceof LOTREntityThrowingAxe && ((LOTREntityThrowingAxe)source.func_76364_f()).getProjectileItem().func_77973_b() == LOTRMod.throwingAxeDwarven) {
                            LOTRLevelData.getData(attackingPlayer).addAchievement(LOTRAchievement.useDwarvenThrowingAxe);
                        }
                    }
                }
            }
        }
        if (!world.field_72995_K && LOTRMod.getNPCFaction((Entity)entity) == LOTRFaction.UTUMNO && LOTRDimension.getCurrentDimensionWithFallback(world) == LOTRDimension.UTUMNO && (attacker = source.func_76346_g()) instanceof EntityPlayer) {
            i = MathHelper.func_76128_c((double)entity.field_70165_t);
            j = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            k = MathHelper.func_76128_c((double)entity.field_70161_v);
            int range = LOTRBlockUtumnoReturnPortalBase.RANGE;
            for (int i1 = -range; i1 <= range; ++i1) {
                for (int j1 = -range; j1 <= range; ++j1) {
                    for (int k1 = -range; k1 <= range; ++k1) {
                        int i2 = i + i1;
                        int j2 = j + j1;
                        int k2 = k + k1;
                        if (world.func_147439_a(i2, j2, k2) != LOTRMod.utumnoReturnPortalBase) continue;
                        int meta = world.func_72805_g(i2, j2, k2);
                        if (++meta >= LOTRBlockUtumnoReturnPortalBase.MAX_SACRIFICE) {
                            world.func_72876_a(attacker, (double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5, 0.0f, false);
                            world.func_147465_d(i2, j2, k2, LOTRMod.utumnoReturnPortal, 0, 3);
                        } else {
                            world.func_72921_c(i2, j2, k2, meta, 3);
                        }
                        LOTRPacketUtumnoKill packet = new LOTRPacketUtumnoKill(entity.func_145782_y(), i2, j2, k2);
                        LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(entity.field_71093_bK, (double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5, 32.0));
                    }
                }
            }
        }
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)entity;
            if (LOTREnchantmentHelper.hasMeleeOrRangedEnchant(source, LOTREnchantment.headhunting)) {
                ItemStack playerHead = new ItemStack(Items.field_151144_bL, 1, 3);
                GameProfile profile = entityplayer.func_146103_bH();
                NBTTagCompound profileData = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)profileData, (GameProfile)profile);
                playerHead.func_77983_a("SkullOwner", (NBTBase)profileData);
                entityplayer.func_70099_a(playerHead, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.entityLiving;
        Random rand = entity.func_70681_au();
        int i = event.lootingLevel;
        if (entity instanceof EntitySheep && LOTRConfig.dropMutton) {
            int meat = rand.nextInt(3) + rand.nextInt(1 + i);
            for (int l = 0; l < meat; ++l) {
                if (entity.func_70027_ad()) {
                    entity.func_145779_a(LOTRMod.muttonCooked, 1);
                    continue;
                }
                entity.func_145779_a(LOTRMod.muttonRaw, 1);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion expl = event.explosion;
        World world = event.world;
        Entity exploder = expl.field_77283_e;
        if (!world.field_72995_K && exploder != null) {
            LOTRBannerProtection.IFilter protectFilter = null;
            if (exploder instanceof LOTREntityNPC || exploder instanceof EntityMob) {
                protectFilter = LOTRBannerProtection.anyBanner();
            } else if (exploder instanceof EntityThrowable) {
                protectFilter = LOTRBannerProtection.forThrown((EntityThrowable)exploder);
            } else if (exploder instanceof EntityTNTPrimed) {
                protectFilter = LOTRBannerProtection.forTNT((EntityTNTPrimed)exploder);
            } else if (exploder instanceof EntityMinecartTNT) {
                protectFilter = LOTRBannerProtection.forTNTMinecart();
            }
            if (protectFilter != null) {
                List blockList = expl.field_77281_g;
                ArrayList<ChunkPosition> removes = new ArrayList<ChunkPosition>();
                for (ChunkPosition blockPos : blockList) {
                    int i = blockPos.field_151329_a;
                    int j = blockPos.field_151327_b;
                    int k = blockPos.field_151328_c;
                    if (!LOTRBannerProtection.isProtected(world, i, j, k, protectFilter, false)) continue;
                    removes.add(blockPos);
                }
                blockList.removeAll(removes);
            }
        }
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        LOTRTitle.PlayerTitle playerTitle;
        PotionEffect nausea;
        EntityPlayerMP entityplayer = event.player;
        String message = event.message;
        String username = event.username;
        ChatComponentTranslation chatComponent = event.component;
        if (LOTRConfig.drunkMessages && (nausea = entityplayer.func_70660_b(Potion.field_76431_k)) != null) {
            int duration = nausea.func_76459_b();
            float chance = (float)duration / 4800.0f;
            chance = Math.min(chance, 1.0f);
            chance *= 0.4f;
            entityplayer.func_70681_au();
            String key = chatComponent.func_150268_i();
            Object[] formatArgs = chatComponent.func_150271_j();
            for (int a = 0; a < formatArgs.length; ++a) {
                Object arg = formatArgs[a];
                String chatText = null;
                if (arg instanceof ChatComponentText) {
                    ChatComponentText componentText = (ChatComponentText)arg;
                    chatText = componentText.func_150260_c();
                } else if (arg instanceof String) {
                    chatText = (String)arg;
                }
                if (chatText == null || !chatText.equals(message)) continue;
                String newText = LOTRDrunkenSpeech.getDrunkenSpeech(chatText, chance);
                if (arg instanceof String) {
                    formatArgs[a] = newText;
                    continue;
                }
                if (!(arg instanceof ChatComponentText)) continue;
                formatArgs[a] = new ChatComponentText(newText);
            }
            chatComponent = new ChatComponentTranslation(key, formatArgs);
        }
        if (LOTRConfig.enableTitles && (playerTitle = LOTRLevelData.getData((EntityPlayer)entityplayer).getPlayerTitle()) != null) {
            ArrayList<Object> newFormatArgs = new ArrayList<Object>();
            for (Object arg : chatComponent.func_150271_j()) {
                if (arg instanceof ChatComponentText) {
                    ChatComponentText componentText = (ChatComponentText)arg;
                    if (componentText.func_150260_c().contains(username)) {
                        ChatComponentText usernameComponent = componentText;
                        IChatComponent titleComponent = playerTitle.getFullTitleComponent((EntityPlayer)entityplayer);
                        IChatComponent fullUsernameComponent = new ChatComponentText("").func_150257_a(titleComponent).func_150257_a((IChatComponent)usernameComponent);
                        newFormatArgs.add(fullUsernameComponent);
                        continue;
                    }
                    newFormatArgs.add(componentText);
                    continue;
                }
                newFormatArgs.add(arg);
            }
            ChatComponentTranslation newChatComponent = new ChatComponentTranslation(chatComponent.func_150268_i(), newFormatArgs.toArray());
            newChatComponent.func_150255_a(chatComponent.func_150256_b().func_150232_l());
            for (Object sibling : chatComponent.func_150253_a()) {
                newChatComponent.func_150257_a((IChatComponent)sibling);
            }
            chatComponent = newChatComponent;
        }
        event.component = chatComponent;
    }

    public int getBurnTime(ItemStack fuel) {
        return 0;
    }
}

